/*
 * Decompiled with CFR 0.152.
 */
package com.hpfxd.pandaspigot.paperclip;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Agent {
    public static void premain(String agentArgs, Instrumentation inst) {
    }

    static void addToClassPath(Path paperJar) {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (!(loader instanceof URLClassLoader)) {
            throw new RuntimeException("System ClassLoader is not URLClassLoader");
        }
        try {
            Method addURL = Agent.getAddMethod(loader);
            if (addURL == null) {
                System.err.println("Unable to find method to add Paper jar to System ClassLoader");
                System.exit(1);
            }
            addURL.setAccessible(true);
            addURL.invoke((Object)loader, paperJar.toUri().toURL());
        }
        catch (IllegalAccessException | InvocationTargetException | MalformedURLException e) {
            System.err.println("Unable to add Paper Jar to System ClassLoader");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static Method getAddMethod(Object o) {
        Class<?> clazz = o.getClass();
        Method m = null;
        while (m == null) {
            try {
                m = clazz.getDeclaredMethod("addURL", URL.class);
            }
            catch (NoSuchMethodException ignored) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                return null;
            }
        }
        return m;
    }
}

