/*
 * Decompiled with CFR 0.152.
 */
package com.hpfxd.pandaspigot.paperclip.libs.org.tukaani.xz;

import com.hpfxd.pandaspigot.paperclip.libs.org.tukaani.xz.DeltaEncoder;
import com.hpfxd.pandaspigot.paperclip.libs.org.tukaani.xz.DeltaInputStream;
import com.hpfxd.pandaspigot.paperclip.libs.org.tukaani.xz.DeltaOutputStream;
import com.hpfxd.pandaspigot.paperclip.libs.org.tukaani.xz.FilterEncoder;
import com.hpfxd.pandaspigot.paperclip.libs.org.tukaani.xz.FilterOptions;
import com.hpfxd.pandaspigot.paperclip.libs.org.tukaani.xz.FinishableOutputStream;
import com.hpfxd.pandaspigot.paperclip.libs.org.tukaani.xz.UnsupportedOptionsException;
import java.io.InputStream;

public class DeltaOptions
extends FilterOptions {
    public static final int DISTANCE_MIN = 1;
    public static final int DISTANCE_MAX = 256;
    private int distance = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DeltaOptions() {
    }

    public DeltaOptions(int n) throws UnsupportedOptionsException {
        this.setDistance(n);
    }

    public void setDistance(int n) throws UnsupportedOptionsException {
        if (n < 1 || n > 256) {
            throw new UnsupportedOptionsException("Delta distance must be in the range [1, 256]: " + n);
        }
        this.distance = n;
    }

    public int getDistance() {
        return this.distance;
    }

    public int getEncoderMemoryUsage() {
        return DeltaOutputStream.getMemoryUsage();
    }

    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream) {
        return new DeltaOutputStream(finishableOutputStream, this);
    }

    public int getDecoderMemoryUsage() {
        return 1;
    }

    public InputStream getInputStream(InputStream inputStream) {
        return new DeltaInputStream(inputStream, this.distance);
    }

    FilterEncoder getFilterEncoder() {
        return new DeltaEncoder(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException();
        }
    }

    static {
        $assertionsDisabled = !DeltaOptions.class.desiredAssertionStatus();
    }
}

